/*
 * Creare una classe Animale che abbia come attributi nome e nZampe
 * Realizzare, nella classe Esercizio, i metodi riportati.
 * Realizzare inoltre il metodo main, nel quale si devono istanziare alcuni oggetti 
 * della classe Animale, salvandoli in un ArrayList. 
 * Testare successivamente i metodi della classe Esercizio
 */

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Main 
{
    public static void main(String[] args)
    {
        Main main = new Main();
        
        //ArrayList
        ArrayList<Animale> animaliArray = new ArrayList<Animale>();      
        animaliArray.add(new Animale("Zebra",4));
        animaliArray.add(new Animale("Gallina",2));
        animaliArray.add(new Animale("Struzzo",2));      

        int risultatoSommaZampeIterator = main.sommaZampeIterator(animaliArray);
        System.out.println("sommaZampeIterator: " + risultatoSommaZampeIterator);

        //ArrayList -> Vector
        Vector<Animale> animaliVector = main.arrayListToVector(animaliArray);
        System.out.println("sommaZampeEnumerator: " + main.sommaZampeEnumerator(animaliVector));
        
        //Vector -> ArrayList 
        ArrayList<Animale> animaliArray2 = main.vectorToArrayList(animaliVector);
        System.out.println("sommaZampeIterator: " + main.sommaZampeIterator(animaliArray2));
    }


    /*
     * creare il metodo sommaZampeIterator che prenda in input un ArrayList<Animale>, 
     * e restituisca un Vector<Animale> che contenga gli stessi elementi dell'ArrayList in input
     * utilizzare un Iterator
     */
    public int sommaZampeIterator(ArrayList<Animale> arrayList){
        int somma = 0;
        Iterator<Animale> iterator = arrayList.iterator();
        while(iterator.hasNext()){
            Animale animale = iterator.next();
            somma += animale.getNZampe(); 
        }
        return somma;
    }
    
    /*
     * creare il metodo arrayListToVector che prenda in input un ArrayList<Animale>, 
     * e restituisca la somma delle zampre degli animali
     * utilizzare il costrutto for nella rappresentazione foreach
     */
    public Vector<Animale> arrayListToVector(ArrayList<Animale> arrayList)
    {
        Vector<Animale> vector = new Vector<Animale>();
        for(Animale animale : arrayList) {
            vector.add(animale);
        }
        return vector;
    }
    
    
    
    /*
     * creare il metodo sommaZampeEnumerator che prenda in input un Vector<Animale>, 
     * e restituisca la somma delle zampre degli animali
     * utilizzare un Enumerator
     */
    public int sommaZampeEnumerator(Vector<Animale> vector){
        int somma = 0;
        //si scorre ogni elemento del vector tramite la classe Enumerator
        Enumeration<Animale> enumerator = vector.elements();
        while (enumerator.hasMoreElements()){
            somma += enumerator.nextElement().getNZampe();
        }
        return somma;
    }
    
    /*
     * creare il metodo vectorToArrayList che prenda in input un Vector<Animale>, 
     * e restituisca un ArrayList<Animale> che contenga gli stessi elementi del Vector in input
     * utilizzare il costrutto for standard
     */
    public ArrayList<Animale> vectorToArrayList(Vector<Animale> vector)
    {
        ArrayList<Animale> arrayList = new ArrayList<Animale>();
        for(int i = 0; i < vector.size(); i++) {
            Animale a = vector.get(i);
            arrayList.add(a);
        }
        return arrayList;
    }
}